;;; -*- Mode:Common-Lisp; Package:FED; Fonts:(MEDFNT HL12B HL121B*I MEDFNT MEDFNTB); Base: 10 -*-

1;;;                           RESTRICTED RIGHTS LEGEND
;;;Use, duplication, or disclosure by the Government is subject to restrictions as set forth in
;;;subdivision (c)(1)(ii) of the Rights in Technical Data and Computer Software clause at 52.227-7013.
;;;TEXAS INSTRUMENTS INCORPORATED, P.O. BOX 2909, AUSTIN, TEXAS 78769
;;; Copyright (C) 1989 Texas Instruments Incorporated. All rights reserved.*


;1;; MAINTENANCE NOTE:  These data structures and symbols were taken from "Inside Macintosh" *
;1;; Volume I, "The Font Manager".*

;1;; MACINTOSH FONT MANAGER DEFINITIONS:*
;1;;   Ascent - distance from base line to top of font box (i.e., the area normally occupied by*
;1;;      capital letters.*
;1;;   Character Offset - distance from left edge of character rectange to character origin (i.e.,*
;1;;      the area normally occupied by a left kern)*
;1;;   Character Rectangle - the imaginary box completely enclosing a character including kerning but*
;1;;      excluding surrounding whitespace and leading.  Its size is equal to font height and image width.*
;1;;   Character Width - distance from one charcter's charcter origin to the charcter origin of the next*
;1;;      character on the line.  If the image width is wider than the character width or if there is a*
;1;;      character offset, then adjacent characters may overlap.*
;1;;   Descent - distance from base line to bottom of font box (i.e., the area normally occupied by*
;1;;      the descenders of lower case letters)*
;1;;   Font Height - height of the font rectangle which is equal to ascent plus descent.*
;1;;   Font Rectangle - the imaginary box complete enclosing a character including its surrounding whitespace*
;1;;      and its kerning by excluding leading between lines.*
;1;;   Leading - distance between the bottom of one font rectangle on one line and the top of the*
;1;;      font rectangle on the next lower line.*


;1;; IMPLEMENTATION NOTE:*
;1;; For Explorer font definitions, the tops of the capital ASCII letters touches the top of the character box.*
;1;; For Macintosh font definitions, the tops of those same letters is typically two pixels short of the top*
;1;; of the charcter box to allow room for diacritical marks over capatial letters on some of the extended-ASCII*
;1;; characters.*
;1;;*
;1;; Therefore, when an Explorer font is converted into a Macintosh font, the height of the Explorer charcter box*
;1;; is incremented by 2 and two rows of empty pixels are added above each Explorer character's bitmap as it is*
;1;; copied into the FontRec's bitImage array.*

;1;; FontRec Data Type Declaration*
(defstruct 4(FontRec *(:predicate nil) (:copier nil) (:conc-name "3FR-*"))
  ;1; the first slot is for identification purposes only and is not part of the true Mac record*
  explorer-font-name  ;1name of Explorer font represented by this FontRec as a string*

  ;1; the following slots are represented by 2-byte integers on the Mac side*
  fontType	      ;1either propFont (#x9000) for proportional or fixedFont (#xB000) for fixed-width*
  firstChar	      ;1ASCII code of first character represented in the font (i.e., all 255 need not be present)*
  lastChar	      ;1ASCII code of last character represented in the font (which is the missing symbol)*
  widMax	      ;1maximum character width*
  kernMax	      ;1negative of maximum kern (i.e., kernMax <= 0)*
  nDescent	   1    *;1negative of descent (see below)*
  fRectWidth	   1    *;1width of font rectangle*
  fRectHeight	   1    *;1height of font rectangle*
  owTLoc	   1    *;1offset to offset/width table*
  ascent	   1    *;1ascent (i.e., called `baseline' in Explorer fonts)*
  descent	   1    *;1descent*
  leading	   1    *;1leading*
  rowWords	      ;1row width of bitImage array in 16-bit integers*

  ;1; the following slots are represented by arrays of 16-bit integers on the Mac side*
  bitImage	      ;1a 2char-rectangle-height* x 2total-font-char-width*/16 2D array*
                      ;1  of (unsigned-byte 16) elements defining the character rectangles of this font.*
                      ;1  CAUTION:  Inside Macintosh, Vol I, defines this array as*
		      ;1        ARRAY[1..2rowWords*, 1..2fRectHeight*] OF INTEGER*
                      ;1  which implies the height (i.e., pixel rows) varies the fastest.  However,*
                      ;1  it is the pixel columns which varies the fastest.*
  locTable	      ;1an array of (unsigned-byte 16) elements long enough to hold all characters*
                      ;1  in the font (including entries for non-existent characters) up to the lastChar*
                      ;1  (inclusive) plus two extra entries.* 1 Only firstChar thru lastChar+2 characters*
                      ;1  are output to the Mac by WRITE-FONTREC.*
  owTable	      ;1a 2D array of (unsigned-byte 8) whose first dimension is the same length as*
                      ;1  locTable above and whose second dimension is 2.* 1 Only firstChar thru lastChar+2*
                      ;1  characters are output to the Mac by WRITE-FONTREC and the two bytes in the*
                      ;1  second dimension are output as one 16-bit byte.*
  );1;FontRec*


;1;; IMPLEMENTATION NOTE:*
;1;; The two following tables, *EXPLORER-TO-MAC-CHARACTER-CODE-MAP**
;1;; and  *EXPLORER-TO-MAC-CHARACTER-CODE-MAP*, translate between *
;1;; Explorer and Macintosh character sets.  These tables were extracted from*
;1;; SYS:KERNEL;MX-KEYBOARD-SUPPORT.LISP, a file which is normally loaded*
;1;; only on the microExplorer.  Note that these tables are defined with DEFVARs*
;1;; which means that the mappings shown below will NOT be used if these variables*
;1;; already exist in your load band.*
;1;;*
;1;; The Explorer to Mac mapping table -- X means that there is no exactly *
;1;; corresponding character on the Mac character set, so the character is *
;1;; mapped to something which, wherever possible, has some similarity of *
;1;; appearance or meaning.)  This mapping is used by NFS and by the window *
;1;; system when writing using Macintosh Times or Helvetica fonts.  (Note that *
;1;; not all of the Macintosh fonts include the glyphs for character codes D9 *
;1;; through FF, and that CPTFONT is handled separately using a customized font *
;1;; for the Lisp Machine character set.)*

;;;      00 10 20 30 40 50 60 70 80 90 A0 B0 C0 D0 E0 F0 
;;;  00    X     0  @  P  `  p     X        X    X  
;;;  01  X  X  !  1  A  Q  a  q  X  X              
;;;  02  X  X  "  2  B  R  b  r  X  X    X          
;;;  03  X  X  #  3  C  S  c  s  X  X    X          
;;;  04  X  X  $  4  D  T  d  t  X  X  X            
;;;  05  X  X  %  5  E  U  e  u  X  X              
;;;  06  X  X  &  6  F  V  f  v  X  X  X            
;;;  07    X  '  7  G  W  g  w  X  X    X    X      
;;;  08  X  X  (  8  H  X  h  x     X    X          
;;;  09  X  X  )  9  I  Y  i  y     X    X          
;;;  0A  X    *  :  J  Z  j  z     X              
;;;  0B  X    +  ;  K  [  k  {  X  X              
;;;  0C  X    ,  <  L  \  l  |     X    X          
;;;  0D  X    -  =  M  ]  m  }     X    X    X    X  
;;;  0E    X  .  >  N  ^  n  ~  X  X    X    X    X  
;;;  0F    X  /  ?  O  _  o    X  X  X            

(defvar4 tv:*EXPLORER-TO-MAC-CHARACTER-CODE-MAP**
	      (MAKE-ARRAY 256. :element-type '(unsigned-byte 8)
			  :initial-contents
    ;;   0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
    #x'(A5 FE F0 FD F6 F7 CF B9 C4 C3 C6 A0 E0 B7 B0 B6   ;0 
	D2 D3 BD C9 DF CE B8 D1 DC DD AD D7 B2 B3 C5 F9   ;1
	20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F   ;2 
	30 31 32 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F   ;3
	40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F   ;4
	50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F   ;5
	60 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F   ;6
	70 71 72 73 74 75 76 77 78 79 7A 7B 7C 7D 7E BA   ;7
	00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F   ;8
 	10 11 12 13 14 15 16 17 18 19 1A 1B 1C 1D 1E 1F   ;9
	CA C1 A2 A3 DB B4 DA A4 AC A9 BB C7 C2 D0 A8 F8   ;A
	A1 B1 E2 E3 AB B5 A6 E1 FC F5 BC C8 D4 E4 D5 C0   ;B
	CB E7 E5 CC 80 81 AE 82 E9 83 E6 E8 ED EA EB EC   ;C
	DE 84 F1 EE EF CD 85 FA AF F4 F2 F3 86 D9 FB A7   ;D
	88 87 89 8B 8A 8C BE 8D 8F 8E 90 91 93 92 94 95   ;E
	7F 96 98 97 99 9B 9A D6 BF 9D 9C 9E 9F FF AA D8)) ;F
    ;;   0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
  "2This table maps an Explorer character code to the Mac character code which would
generate the similar screen image.  This version is used by the window system 
when writing using Macintosh Times or Helvetica fonts, and is used by NFS when 
writing to a Macintosh file.*")


;1;; The Mac to Explorer mapping table is the exact inverse.*
;;;      00 10 20 30 40 50 60 70 80 90 A0 B0 C0 D0 E0 F0 
;;;  00     X     0  @  P  `  p      X        X  X  
;;;  01  X  X  !  1  A  Q  a  q            X      
;;;  02  X  X  "  2  B  R  b  r            X  X    
;;;  03  X  X  #  3  C  S  c  s          X  X  X    
;;;  04  X  X  $  4  D  T  d  t          X  X  X    
;;;  05  X  X  %  5  E  U  e  u          X  X    X  
;;;  06  X  X  &  6  F  V  f  v          X      X  
;;;  07  X  X  '  7  G  W  g  w        X        X  
;;;  08     X  (  8  H  X  h  x        X          
;;;  09     X  )  9  I  Y  i  y          X  X    X  
;;;  0A     X  *  :  J  Z  j  z      X          X  
;;;  0B  X  X  +  ;  K  [  k  {                X  
;;;  0C     X  ,  <  L  \  l  |            X      
;;;  0D     X  -  =  M  ]  m  }        X    X    X  
;;;  0E  X  X  .  >  N  ^  n  ~          X  X    X  
;;;  0F  X  X  /  ?  O  _  o            X  X    X  

(defvar4 tv:*MAC-TO-EXPLORER-CHARACTER-CODE-MAP**
	 (let ((table (MAKE-ARRAY 256. :element-type '(unsigned-byte 8))))
	   (dotimes (i 256.)
	     (setf (aref table (aref tv:*Explorer-to-mac-character-code-map* i))
		   i))
	   table)
2   *"2This table maps a Macintosh character code to the corresponding Explorer
character code.*")


(defun 4FONT-TO-FONTREC *(explorer-fd &optional FontRec-output-filename)
  "2Converts the font information about an Explorer font, EXPLORER-FD,
into a FED:FONTREC structure which contains the information in the format
needed by the Macintosh Font Manager for use as the resource data portion of a
font resource.

EXPLORER-FD may be an Explorer font name in the form of a string or symbol,
an Explorer FED:FONT-DESCRIPTOR structure, or a TV:FONT structure. 

If FONTREC-OUTPUT-FILENAME is specified, then WRITE-FONTREC is called
with newly created FontRec before returning.

Returns the newly created FONTREC and, if direct output to a file was requested,
the output truename.  Otherwise, the second value is NIL*"

  (declare (values FontRec &optional truename))
  (check-type explorer-fd (or TV:FONT FONT-DESCRIPTOR string (and symbol (not null)))
	      "3a FED:FONT-DESCRIPTOR or TV:FONT object or an Explorer font name as a symbol or string*")

  ;1; normalize input argument EXPLORER-FD into a FED:FONT-DESCRIPTOR*
  (setf explorer-fd (typecase explorer-fd
		      ((or symbol string)
		       (font-get-fd (intern-font-name explorer-fd)))
		      (tv:font
		       (font-into-font-descriptor explorer-fd))))

  ;1; validate font descriptor before continuing*
  (when (not (dotimes (explorer-code (length explorer-fd) nil)	           ;1 defaults to false*
	       (when (aref explorer-fd explorer-code) (return t))))	   ;1 true if any character exists
3    **(error "3No character exist in this font.*"))

  (when (not (zerop (fd-rotation explorer-fd)))
    (error "3Cannot convert a rotated font.*"))

  (when (fd-double-width-p explorer-fd)
    (error "3Cannot convert a double-width font.*"))

  (when (or (> (max-raster-width  explorer-fd) 254)
	    (> (+ (max-raster-height explorer-fd) 2) 127)) ;1include two extra rows of pixels*
    (error "3The size of this font, ~DHx~DW, is larger than the Macintosh limit of 127Hx254W.*"
	   (+ (max-raster-height explorer-fd) 2) (max-raster-width  explorer-fd)))


  ;1; create Macintosh Font Manager FontRec structure*
  (let* ((FontRec           (make-FontRec	           ;1 structure to be initialized and returned*
			   :explorer-font-name (string (fd-name explorer-fd))))
	 (mac-fd            (let ((fd (make-array 256)))   ;1 Explorer CDs ordered by Mac character codes*
			      (dotimes (explorer-code (length explorer-fd) fd)
				(setf (aref fd (aref tv:*explorer-to-mac-character-code-map* explorer-code))
				      (aref explorer-fd explorer-code)))))
	 (mac-fd-length     (length mac-fd))
	 (firstChar         nil)		           ;1 working copy of (FR-firstChar FontRec)*
	 (lastChar          nil)		           ;1 working copy of (FR-lastChar  FontRec)*
	 );1;let* bindings*

    (labels (4(CD *(mac-code)
	      "2returns FED:CHARACTER-DESCRIPTOR as true if character represented by ASCII
               3   *code MAC-CODE exists in th3e *MAC-FD font*"
	      (when (< -1 mac-code mac-fd-length)
		(aref mac-fd mac-code)))

	    (4CD-WIDTH* (mac-code)
	      "2returns width of Macintosh character represented by ASCII code MAC-CODE
               3   *or 0 for non-existent character*"
	      (let ((cd (cd mac-code)))
		(if cd
		    (cd-char-width cd)	   ;1charcter exists, so return its width*
		    0)))		   ;1character does not exist, so return 0*
	    );1; labels bindings*

      ;1; fontType defined below after lastChar, widmax, and missing symbol construction


        *;1; firstChar - index of first Macintosh character*
      (setf (FR-firstChar FontRec)
	    (dotimes (mac-code mac-fd-length)
	      (when (cd mac-code)
		;1; then this character exists, so return it immediately*
		(return mac-code))))
      (setf firstChar (FR-firstChar FontRec))	   ;1 make a local working copy


        *;1; lastChar - index of the last existing Macintosh character.  The missing symbol is one past lastChar.*
      (dotimes (mac-code mac-fd-length)
	(when (cd mac-code)
	  ;1; then this character exists, so record it in case it is the last*
	  (setf (FR-lastChar FontRec) mac-code)))
      (setf lastChar (FR-lastChar FontRec))	   ;1 make a local working copy*


      ;1; widMax - index of widest existing character*
      (setf (FR-widMax  FontRec) (max-raster-width explorer-fd))


1        *;1; fontType - fontType is fixedFont, #xB000, if widths for existing charcters are the same,*
      ;1; Otherwise, it is propFont, #x9000, if they vary*
      (setf (FR-fontType FontRec)
	    (dotimes (mac-code mac-fd-length #xB000)	   ;1return fixedFont by default*
	      (when (and (cd mac-code)
			 (/= (FR-widMax FontRec) (cd-width mac-code)))
	1          *;1; then we've found a character with a different width, so return propFont*
		(return #x9000))))


      ;1; kernMax - negative of largest left kern of all existing characters*
      (setf (FR-kernMax FontRec) MOST-POSITIVE-FIXNUM)
      (dotimes (mac-code mac-fd-length)
	(when (cd mac-code) 
	  (setf (FR-kernMax FontRec) (min (FR-kernMax FontRec) (- (cd-char-left-kern (cd mac-code)))))))


      ;1; descent & nDescent - line spacing less baseline*
      (setf (FR-descent  FontRec) (- (fd-line-spacing explorer-fd) (fd-baseline explorer-fd)))
      (setf (FR-nDescent FontRec) (- (FR-descent FontRec)))

      
      ;1; fRectWidth & fRectHeight *
      (setf (FR-fRectWidth  FontRec) (max-raster-width  explorer-fd))
      (setf (FR-fRectHeight FontRec) (+ (max-raster-height explorer-fd) 2))	   ;1add two rows of pixels*


      ;1; owTLoc - defined below after owTable*


      ;1; ascent - equivalent to the Explore font baseline (but with our two extra pixels added)*
      ;1; descent - see nDescent above*
      (setf (FR-ascent FontRec) (+ (fd-baseline explorer-fd) 2))   ;1 add two rows of pixels at the top*
      

      ;1; leading*
      (setf (FR-leading FontRec) 1)
      
      ;1; bitImage, locTable, and rowWords*
      (fontrec-arrays fontrec mac-fd)

      ;1; return FontRec structure and output truename if WRITE-FONTREC was called*
      (values FontRec
	      (when (not (null FontRec-output-filename))
		;1; then we have an implied request to output this FontRec directly to a file, so do it.*
		(write-FontRec FontRec FontRec-output-filename)))
      );1;labels*
    );1;let**
  );1;font-to-FontRec*



(defun 4FONTREC-ARRAYS *(FontRec mac-fd)
  "2Updates FontRec, an FED:FONTREC structure, with the bitImage, LocTable, and owTable
array information derived from MAC-FD, an array of FED:CHAR-DESCRIPTOR structures ordered
according to the Macintosh character code.*"

  (declare (values ignore))
  (check-type FontRec FontRec)
  (check-type mac-fd (vector t))

  (labels (4(CD *(mac-code)
	      "2returns FED:CHARACTER-DESCRIPTOR as true if character represented by ASCII
               3   *code MAC-CODE exists in th3e *MAC-FD font*"
	      (when (< -1 mac-code (length mac-fd))
		(aref mac-fd mac-code)))

	   (4CD-WIDTH* (mac-code)
	      "2returns width of Macintosh character represented by ASCII code MAC-CODE
               3   *or 0 for non-existent character*"
	      (let ((cd (cd mac-code)))
		(if cd
		    (cd-char-width cd)	   ;1charcter exists, so return its width*
		    0)))

	   (4CD-IMAGE-START* (mac-code)
	      "2returns the column within cd-width where the non-blank image starts
3               *or 0 if character does not exist or if it is blank*"
	      (block cd-image-start
		(let ((cd (cd mac-code)))	   ;1cd array is height x width (i.e., rows x columns)*
		  (if cd
		1        *;1; then this character exists, so process it*
		      (dotimes (cd-column (array-dimension cd 1) 0)  ;1 return 0 for all blank character*
			(dotimes (cd-row (array-dimension cd 0))
			  (when (plusp (aref cd cd-row cd-column))
			1     *;1; then we have found the first non-blank column, so return cd-column*
			    (return-from cd-image-start cd-column))))
		1        *;1; else this character does not exist, so return 0*
		      0))))

	    (4CD-IMAGE-END *(mac-code)
	      "2returns the column within cd-width one beyond where the non-blank image ends
3               *or 0 if character does not exist or if it is blank*"
	      (block cd-image-end
		(let ((cd (cd mac-code)))	   ;1cd array is height x width (i.e., rows x columns)*
		  (if cd
		1        *;1; then this character exists, so process it*
		      (do ((cd-column (1- (array-dimension cd 1)) (1- cd-column)))
			  ((minusp cd-column) 0)	   ;1 return 0 for all blank character*
			(dotimes (cd-row (array-dimension cd 0))
			  (when (plusp (aref cd cd-row cd-column))
			1     *;1; then we have found the first non-blank column, so return cd-column*
			    (return-from cd-image-end (1+ cd-column)))))
		1        *;1; else this character does not exist, so return 0*
		      0))))

	    (4CD-IMAGE-WIDTH *(mac-code)
	      "2returns cd-width less all blank pixel columns on the left and rigtht
              3    *or 0 for non-existent character*"
	      (- (cd-image-end mac-code) (cd-image-start mac-code)))
	 );1;labels*
    (let* ((firstChar             (FR-firstChar FontRec))
	   (lastChar              (FR-lastChar  FontRec))
	   (widMax                (FR-widMax    FontRec))
	   (kernMax               (FR-kernMax   FontRec))
	   (ascent                (FR-ascent    FontRec))
	   (rowWords              nil)
	   (fRectHeight           (FR-fRectHeight FontRec))	   ;1 already include two extra rows of pixels*
	   (bitImage              nil)	   ;1fRectHeight x rowWords of (unsigned-byte 16)*
	   (bitImage-1b           nil)	   ;1fRectHeight x rowWords*16 of bit [CAUTION: bits are reversed in byte]*
	   (locTable              (make-array (+ lastChar 3)
					      :element-type '(signed-byte 16)))
	   (total-font-char-width 0))	   ;1sum of all character widths in the font*
	   
      ;1; determine first dimension of bitImage*
      (dotimes (mac-code (+ lastchar 1))	   ;1last 2 entries don't represent mac-codes*
	(setf (aref locTable mac-code) total-font-char-width)
	(incf total-font-char-width (cd-image-width mac-code)))	   ;1Note: missing charcters increment by 0*

      ;1; next to last entry in locTable (i.e., one past lastChar) is missing symbol which is widMax wide*
      (setf (aref locTable (+ lastchar 1)) total-font-char-width)
      (incf total-font-char-width widMax)
      
      ;1; last entry in locTable (i.e., two past lastChar) points to one bit past last end of bitImage*
      (setf (aref locTable (+ lastchar 2)) total-font-char-width)
      (setf (FR-locTable FontRec) locTable)
      
      ;1; calculate rowWords*
      (setf (FR-rowWords FontRec) (ceiling total-font-char-width 16))	   ;1Mac `word' is 16 bits*
      (setf rowWords (FR-rowWords FontRec))
      
      ;1; make the bitImage array and displace an ART-1b array on top of it*
      (setf bitImage              (make-array (list fRectHeight rowWords)
					  :element-type '(unsigned-byte 16)))
      (setf bitImage-1b           (make-array (list fRectHeight (* rowWords 16))
					  :element-type 'bit :displaced-to bitImage))
      (setf (FR-bitImage FontRec) bitImage)
      
      ;1; copy individual character bitmaps into bitImage*
      (dotimes (mac-code (1+ lastChar))	   ;1stop AFTER processing lastChar*
	(let ((cd          (cd mac-code))  ;1dimensions are height x width (i.e., rows x columns)*
	      (column-disp (aref locTable mac-code))  ;1starting column displacement into row of bitImage-1b array*
	      (image-start (cd-image-start mac-code))
	      (image-end   (cd-image-end   mac-code)))
	  (when (> image-end image-start)
	    ;1; then this character exists and there is an image to copy, so copy it into locTable position*
	    
	    ;1; NOTE:  At this point, bitImage has two more rows than the character descriptor, cd.  cd is to be copied*
	    ;1; into bitImage leaving the first two rows of bitImage blank.  The two DO indexes below, CD-ROW and CD-COLUMN,*
	    ;1; are relative to the character descriptor bit map being copied from.  The must be appropriately displaced*
	    ;1; 2 down and COLUMN-DISP over to be used with bitImage.*
	    (dotimes (cd-row (array-dimension cd 0))
	      (do ((cd-column image-start (1+ cd-column))
		   (bi-column column-disp (1+ bi-column)))
		  ((>= cd-column image-end))
		(setf (aref bitImage-1b (+ cd-row 2) bi-column) (aref cd cd-row cd-column)))))))

      ;1; copy missing symbol character into bitImage immediately after lastChar*
      (do ((bi-row      2   (1+ bi-row))   ;1 skip first two rows of extra pixels at the top*
	   (column-disp (aref locTable (1+ lastChar))))
	  ((>= bi-row ascent))
	(if (or (= bi-row 2) (= bi-row (1- ascent)))
	1      *;1; then this is the first or last row of the missing symbol box, so draw solid line*
	    (dotimes (image-column widMax)
	      (setf (aref bitImage-1b bi-row (+ image-column column-disp)) 1))

	1      *;1; else this is a row in the middle of the box, so draw only ends*
	    (setf (aref bitImage-1b bi-row (+ 0           column-disp)) 1          ;1 left end*
		  (aref bitImage-1b bi-row (+ (1- widMax) column-disp)) 1)))	   ;1right end*
      
1        *;1; CAUTION:  Displacing bitImage-1b on top of bitImage has the effect of loading each word of bitImage*
      ;1; with the correct bits, but in the reverse order.  Therefore, each word of bitImage must be bit-reversed*
      ;1; before continuing.*
      (dotimes (row fRectHeight)
	(dotimes (column rowWords)
	  (let ((old-word (aref bitImage row column))
		(new-word 0))		   ;1 bit-reversed version of old-word*
	    (dotimes (bit 16)
	      (setf new-word (dpb (ldb (byte 1 bit) old-word) (byte 1 (- 15 bit)) new-word)))
	    (setf (aref bitImage row column) new-word))))
         
      ;1;owTable - Offset (i.e., left-kern).  In the second dimension of the table, 0=>offset and 1=>width.*
      ;1;#xFF bytes mark the offset and width of non-existent characters and of the last table entry.*
      ;1;After they are created here, the two bytes in the last dimension are treated elsewhere as one*
      ;1;16-bit value*
      (setf (FR-owTable FontRec)
	    (let ((table (make-array (list (+ lastChar 3) 2)	   ;1 room for all chars + missing symbol + end mark*
				     :element-type '(unsigned-byte 8)
				     :initial-element #xFF))
		  (offset-index 0)	   ;1 second dimension subscript constant*
		  (width-index  1))	   ;1 second dimension subscript constant*
	      ;1; append information for missing symbol one entry beyond lastChar*
	      (setf (aref table (1+ lastChar) offset-index) 0)
	      (setf (aref table (1+ lastChar)width-index)  widMax)

	1        *;1; fill in information for all mac codes*
	      (dotimes (mac-code (1+ lastChar) table) ;1process all characters except missing symbol*
		(when (cd mac-code)
		  ;1; then this character exists, so update its offset and width*
		  ;1; IMPLEMENTATION NOTE:  kernMax causes the ENTIRE font to be kerned to the left by |kernMax|.*
		  ;1; The offset is used to get non-kerned characters back into place.  Therefore, a non-kerned*
		  ;1; character has an offers = -KernMax while a fully kerned character has an offset of 0. (Strange...)*
		  (setf (aref table mac-code offset-index) (- (- kernMax) (cd-char-left-kern (cd mac-code))))
		  (setf (aref table mac-code width-index)  (cd-width mac-code))))))
      
      
      ;1; owTLoc = 4 + rowWOrd*fRectHeight + (lastChar-firstChar+3) + 1 [cf. Inside Macintosh, Vol I, p I-232]*
      (setf (FR-owTLoc FontRec)
	    (+ 4			           ;1size of ascent, descent, leading, and rowWords*
	       (* rowWords fRectHeight)            ;1size of bitImage*
	       (+ (- lastChar firstChar) 3)	   ;1size of locTable including all chars, missing symbol, and end mark*
	       1))			           ;1size of owTLoc*
      
      
      ;1; verify total size of bitImage + locTable + owTable < 16K (#x3FFF) words*
      ;1; Note that the entire bitImage array will be output to the Mac, but only first thru last charcters plus one*
      ;1; extra entry are output for the locTable and owTable arrays.*
      (let ((total-size (+ (array-total-size (FR-bitImage FontRec))	   ;1bitImage word size*
			   (+ (- lastChar firstChar) 3)	                   ;1locTable word size*
			   (+ (- lastChar firstChar) 3))))                 ;1owTable word size*
	(when (> total-size #x3FFF)
	3  *(error "3The total size in bytes of the bitImage, locTable, and owTable arrays, ~D,~
                  is greater than the 32K byte Macintosh limit.*"
		 (* total-size 2))))	   ;1 convert TOTAL-SIZE from Mac integers to bytes for printing*
      );1;let**
    );1;labels*
  );1;Fontrec-Arrays*


(defun 4SHOW-bitImage-CHARS *(FontRec &optional (starting-mac-code (FR-firstChar FontRec)))
  "2Displays characters in the bitImage array of FontRec starting at STARTING-MAC-CODE.*"
  (declare (values ignore))
  (check-type FontRec FontRec)

  (let* ((bitImage      (FR-bitImage    FontRec))
	 (fRectWidth    (FR-fRectWidth  FontRec))
	 (fRectHeight   (FR-fRectHeight FontRec))
	 (rowWords      (FR-rowWords    FontRec))
	 (firstChar     (FR-firstChar   FontRec))
	 (lastChar      (FR-lastChar    FontRec))
	 (ascent        (FR-ascent      FontRec))
	 (owTable       (FR-owTable     FontRec))
	 (locTable      (FR-locTable    FontRec))
	 (bitImage-r    (make-array (list fRectHeight rowWords)
				    :element-type '(unsigned-byte 16)))
	 (bitImage-r-1b (make-array (list fRectHeight (* rowWords 16))
				      :element-type 'bit
				      :displaced-to bitImage-r)))

    (send *standard-output* :send-if-handles :clear-screen)
    (format t "3~%Font ~A(#x~2,'0X=`~C' .. #x~2,'0X=`~C'): Font Rectangle ~DHx~DW  Leading ~D~
               ~%     Last location ~D  Last Offset/Width ~D/~D*"
	    (FR-explorer-font-name FontRec)
	    firstChar (aref tv:*mac-to-explorer-character-code-map* firstChar)
	    lastChar  (aref tv:*mac-to-explorer-character-code-map* lastChar)
	    fRectHeight fRectWidth
	    (FR-leading FontRec)
	    (aref locTable (+ lastChar 2))
	    (aref owTable (+ lastChar 2) 0) (aref owTable (+ lastChar 2) 0))
    
    ;1; copy bitImage into bitImage-r bit-reversing each 16-bit word as we go*
    (dotimes (row fRectHeight)
      (dotimes (column rowWords)
	(let ((old-word (aref bitImage row column))
	      (new-word 0))		   ;1 bit-reversed version of old-word*
	  (dotimes (bit 16)
	    (setf new-word (dpb (ldb (byte 1 bit) old-word) (byte 1 (- 15 bit)) new-word)))
	  (setf (aref bitImage-r row column) new-word))))

    (do* ((mac-code      (min starting-mac-code firstChar)       (1+ mac-code))
	  (location      (aref locTable mac-code)                (aref locTable mac-code))
	  (next-location nil)
	  (image-width   nil)
	  (offset        (aref owTable mac-code 0)               (aref owTable mac-code 0))
	  (width         (aref owTable mac-code 1)               (aref owTable mac-code 1)))
	 ((> mac-code (1+ lastChar)))
      
      (setf next-location (aref locTable (1+ mac-code)))
      (setf image-width   (- next-location location))
      
      ;1; special case the missing symbol because it does not represent a true Explorer code*
      (if (= mac-code (1+ lastChar))
	  ;1; then this is the missing symbol*
	  (format t "3~%Missing Symbol (#x~2,'0X): location=~D  offset=~D  width=~D*"
		  mac-code location offset width)
	  ;1; else this is a normal mac code*
	3  *(format t "3~%`~:C' (#x~2,'0X): location=~D  offset=~D  width=~D*"
		  (aref tv:*mac-to-explorer-character-code-map* mac-code) mac-code location offset width))
      (cond ((and (= offset #xFF) (= width #xFF))
	     ;1; case of missing character*
	     (format t "3 - missing character in this font*"))
	    ((zerop image-width)
	     ;1; case of character with blank image*
	     (format t "3 - zero width character*"))
	    (t
	1       *;1; case of some pixels to display*
	     (dotimes (row fRectHeight)
	       (terpri)
	       (dotimes (column image-width)
		 (princ (if (plusp (aref bitImage-r-1b row (+ location column)))
			    #\#
			    (if (= column (1- offset))
				;1; then this is the rightmost kern column*
				#\:
				#\center-dot))))
	       (cond ((= row (1- ascent))
		      (format t "3/ ascent =~D*" ascent))
		     ((= row ascent)
		      (format t "3\\ descent=~D*" (FR-descent FontRec)))))
	     (terpri)))
      );1;do*
    );1;let**
  nil
1   *);1;show-bitImage-chars*
  

(defun 4WRITE-FONTREC *(FontRec filename)
  "2Writes FontRec to FILENAME as an (UNSIGNED-BYTE 8) file.  The 16-bit integers in FONTREC
are written most significant byte first.  The name and type components of the FILENAME are
defaulted to the Explorer font name represented by FontRec and to 'FontRec' respectively.  FILENAME
may also be a stream.
Returns truename of output stream.*"

  (declare (values truename))
  (check-type FontRec fontrec)
  (check-type filename (or pathname string stream))

  (with-open-stream (stream (if (streamp filename)
				filename
			        (open (merge-pathnames filename
						       (make-pathname :host sys:local-host
								      :name (FR-explorer-font-name FontRec)
								3      *:type "3FontRec*"))
				      :direction :output :element-type '(unsigned-byte 8))))	
    (let ((word-pos   0)		   ;1 number of 16-bit words output so far*
	  (owTLoc-pos 0))		   ;1 word-pos at which owTLoc was output*
      
      (flet ((4WRITE-TWO-BYTES* (16-bit-integer)
	     "2writes argument to STREAM as two bytes, most-significant-byte first*"
	     (write-byte (ldb (byte 8 8) 16-bit-integer) stream)
	     (write-byte (ldb (byte 8 0) 16-bit-integer) stream)
	     (incf word-pos))
	1       *);1;flet bindings*

	;1; perform consistency checks*
	(when (and (/= (FR-fontType FontRec) #xB000)
		   (/= (FR-fontType FontRec) #x9000))
	  (warn "3~%fontType in FontRec, #x4,'0X, is neither propFont (#x9000) nor fixedFont (#xB000).*"
		(FR-fontType FontRec)))

	(when (> (FR-firstChar FontRec) (FR-lastChar FontRec))
	  (warn "3~%firstChar, #x~2,'0X, is not less than or equal to lastChar, #x~2,'0X, in FontRec.*"
		(FR-firstChar FontRec) (FR-lastChar FontRec)))

	(when (not (<= 1 (FR-widMax FontRec) (FR-fRectWidth FontRec)))
	  (warn "3~%widMax in FontRec, ~D, is not in the range 1..fRectWidth, ~D.*"
		(FR-widMax FontRec) (FR-fRectWidth FontRec)))
	  
	(when (plusp (FR-kernMax FontRec))
	  (warn "3~%kernMax, ~D, in FontRec is not less than or equal to zero.*"
		(FR-kernMax FontRec)))

	(when (/= (FR-descent FontRec) (- (FR-nDescent FontRec)))
	  (warn "3~%nDescent, ~D, is not equal to -descent, ~D, in FontRec.*"
		(FR-nDescent FontRec) (FR-descent FontRec)))

	(when (> (+ (FR-ascent FontRec) (FR-descent FontRec)) (FR-fRectHeight FontRec))
	  (warn "~%a3scent, ~D, plus descent, ~D, is greater than fRectHeight, ~D, in FontRec.*"
		(FR-ascent FontRec) (FR-descent FontRec) (FR-fRectHeight FontRec)))
	
	(when (/= (FR-fRectHeight FontRec) (array-dimension (FR-bitImage FontRec) 0))
	3  *(warn "3~%*fRectHeight3, ~D, in FontRec not equal tofirst dimension, ~D, of bitImage in FontRec*"
		(FR-fRectHeight FontRec) (array-dimension (FR-bitImage FontRec) 0)))

	(when (/= (FR-rowWords FontRec) (array-dimension (FR-bitImage FontRec) 1))
	  (warn "3~%rowWords, ~D, in FontRec not equal to second dimension, ~D, of bitImage in FontRec*"
		(FR-rowWords FontRec) (array-dimension (FR-bitImage FontRec) 1)))

	;1; output FontRec*
	(write-two-bytes (FR-fontType    FontRec))
	(write-two-bytes (FR-firstChar   FontRec)) 
	(write-two-bytes (FR-lastChar    FontRec)) 
	(write-two-bytes (FR-widMax      FontRec))
	(write-two-bytes (FR-kernMax     FontRec)) 
	(write-two-bytes (FR-nDescent    FontRec)) 
	(write-two-bytes (FR-fRectWidth  FontRec)) 
	(write-two-bytes (FR-fRectHeight FontRec))
	(setf owTLoc-pos word-pos)	           ;1 record position for validation later*
	(write-two-bytes (FR-owTLoc      FontRec)) 
	(write-two-bytes (FR-ascent      FontRec)) 
	(write-two-bytes (FR-descent     FontRec)) 
	(write-two-bytes (FR-leading     FontRec)) 
	(write-two-bytes (FR-rowWords    FontRec))

	;1; bitImage*
	(dotimes (row (FR-fRectHeight FontRec))
	  (dotimes (column (FR-rowWords FontRec))
	    (write-two-bytes (aref (FR-bitImage FontRec) row column))))

	;1; locTable*
	(do ((mac-code (FR-firstChar FontRec) (1+ mac-code)))
	    ((> mac-code (+ (FR-lastChar FontRec) 2)) nil) ;1 write two past lastChar*
	  (write-two-bytes (aref (FR-locTable FontRec) mac-code)))

	;1; owTable*
	(when (/= (- word-pos owTLoc-pos) (FR-owTLoc FontRec))
	  (warn "3~%Position of owTable beyond owTLoc in stream, ~D, does not match owTLoc in FontRec, ~D.*"
		(- word-pos owTLoc-pos) (FR-owtLoc FontRec)))
	(do ((mac-code (FR-firstChar FontRec) (1+ mac-code)))
	    ((> mac-code (+ (FR-lastChar FontRec) 2)) nil) ;1 write two past lastChar*
	  (write-byte (aref (FR-owTable FontRec) mac-code 0) stream)	1   *;1write offset*
	  (write-byte (aref (FR-owTable FontRec) mac-code 1) stream)	1   *;1write width*
	  (incf word-pos))
	);1;flet*
      );1;let*
    (send stream :truename)
    );1;with-open-stream*
  );1;write-fontrec*

(pushnew "3FONTREC*" fs:*copy-file-known-short-binary-types* :test #'string-equal)
